*___________________________________________________________________________________________________

	VECM 01.sas

	Simulation and estimation of the cointegrated model discussed in Chapter 10, section 2:
	m(t) = m(t-1) + u(t)
	p(1,t) = m(t) + c * q(t)
	p(2,t) = m(t-1)

	This program uses the VarianceDecomp macro (in the '/SAS macros' subdirectory).

____________________________________________________________________________________________________;

*	Modify the following statement to set current directory to location of program;
x 'cd c:\Active\EMM Distribution\SAS Programs v0100';
options nodate nocenter nonumber ps=70 ls=100  sasautos=('./Sas Macros','.') nomprint; 
libname SASData '.\Datasets';

ods pdf file='./VECM 01.pdf' style=serifPrinter;

*___________________________________________________________________________________________________;
%macro Simulate(nObs=10000, c=1, sdu=1);
data pData;
	m = 0;
	do t=1 to &nObs;
		u = &sdu*normal(1234);
		m = m+u;
		q1 = sign(normal(2345));
		p1 = m + &c*q1;
		p2 = mLast;
		if t>0 then output;
		keep t p1 p2 m q;
		mLast = m;
	end;
	run;
proc print data=pData (obs=10);
%mend Simulate;

*___________________________________________________________________________________________________;
%macro RunVarmax(nImpulse=15);
proc varmax data=pData;
	model p1 p2 / p=1 print=(impulse(&nImpulse)=(simple)) 
		ecm=(rank=1 ectrend normalize=p1) lagmax=0;
	ods output covInnovation=covInnovation;
	ods output simpleImpulse=simpleImpulse;
	run;
data lastSimpleImpulse;
	set simpleImpulse;
	where lag=&nImpulse;
	drop lag;
	run;
*	Examine alternative variance decompositions;
proc print data=lastSimpleImpulse;
	title 'VECM 01.sas Long-run coefficients'; 
	footnote1 'Note: When all variables in the system refer to the price for the same security,';
	footnote2 'all rows should be equal. If they aren''t, try setting nImpulse to a higher value.';
	run;
	footnote;
%mend RunVarmax;

*___________________________________________________________________________________________________;
%let c=1;
%let sdu=1;
%let nObs=10000;
title 'VECM 01.sas: Simulation and estimation of the cointegrated model used in section 10.2.';
title2	'm(t) = m(t-1) + u(t)';
title3	'p(1,t) = m(t) + c * q(t)';
title4	'p(2,t) = m(t-1)';
title5	'Run A (high c, high sdu)';
title6	"Simulating &nObs observations with c=&c and std.dev. of u=&sdu";
title7 	'Initial data points:';
%Simulate(c=&c, sdu=&sdu);
%RunVarmax;
%VarianceDecomp(dsCov=covInnovation, dsCoeff=lastSimpleImpulse, RowLabel=variable);
%VarianceDecomp(dsCov=covInnovation, dsCoeff=lastSimpleImpulse, RowLabel=variable, perm=p2 p1);

*___________________________________________________________________________________________________;
%let c=.1;
%let sdu=1;
title 'VECM 01.sas: Simulation and estimation of the cointegrated model used in section 10.2.';
title2	'm(t) = m(t-1) + u(t)';
title3	'p(1,t) = m(t) + c * q(t)';
title4	'p(2,t) = m(t-1)';
title5	'Run B (low c, high sdu: p1 becomes a better signal of the efficient price)';
title6	"Simulating &nObs observations with c=&c and std.dev. of u=&sdu";
title7 	'Initial data points:';
%Simulate(c=&c, sdu=&sdu);
%RunVarmax;
%VarianceDecomp(dsCov=covInnovation, dsCoeff=lastSimpleImpulse, RowLabel=variable);
%VarianceDecomp(dsCov=covInnovation, dsCoeff=lastSimpleImpulse, RowLabel=variable, perm=p2 p1);


*___________________________________________________________________________________________________;
%let c=1;
%let sdu=.1;
title 'VECM 01.sas: Simulation and estimation of the cointegrated model used in section 10.2.';
title2	'm(t) = m(t-1) + u(t)';
title3	'p(1,t) = m(t) + c * q(t)';
title4	'p(2,t) = m(t-1)';
title5	'Run C (high c, low sdu: p2 becomes a better signal of the efficient price)';
title6	"Simulating &nObs observations with c=&c and std.dev. of u=&sdu";
title7 	'Initial data points:';
%Simulate(c=&c, sdu=&sdu);
%RunVarMax;
%VarianceDecomp(dsCov=covInnovation, dsCoeff=lastSimpleImpulse, RowLabel=variable);
%VarianceDecomp(dsCov=covInnovation, dsCoeff=lastSimpleImpulse, RowLabel=variable, perm=p2 p1);

ods _all_ close;

